<?php
/**
 * Plugin Name: WP Nice Topbar
 * Description: Create and manage your top bars
 * Version: 1.1.0
 * Author: Duy Nguyen <duyngha@gmail.com>
 * Author URI: https://www.duyngha.com
 * Plugin URI: https://www.duyngha.com
 * License: MIT
 */

require __DIR__ . '/vendor/autoload.php';

use WPNT\Core\Topbar;

/**
 * create main class
 * 
 * @package wpnt
 * @since   1.0.2
 */
if (!class_exists('WPNT')) {
	class WPNT
	{
		/**
		 * @var array $default_options
		 */
		protected $defaultOptions = array(
			'wpnt_topbar_label' => '',
			'wpnt_topbar_name'  => '',

			// content option
			'wpnt_text_cont'        => '',
			'wpnt_text_align'       => 'center', 
			'wpnt_text_size'        => '16',
			'wpnt_text_color'       => 'FFFFFF',
			'wpnt_text_weight'      => '',
			'wpnt_text_style'       => '',
			'wpnt_text_decoration'  => '',
			'wpnt_text_line_height' => '50',

			'wpnt_text_padding_top'    => '0',
			'wpnt_text_padding_right'  => '0',
			'wpnt_text_padding_bottom' => '0',
			'wpnt_text_padding_left'   => '0',

			'wpnt_text_margin_top'    => '0',
			'wpnt_text_margin_right'  => '0',
			'wpnt_text_margin_bottom' => '0',
			'wpnt_text_margin_left'   => '0',

			// logo options

			'wpnt_logo_url'        => '',
			'wpnt_logo_link'       => '#',
			'wpnt_logo_width'      => '0',
			'wpnt_logo_height'     => '0',
			// logo padding
			'wpnt_logo_padding_top'    => '0',
			'wpnt_logo_padding_right'  => '0',
			'wpnt_logo_padding_bottom' => '0',
			'wpnt_logo_padding_left'   => '0',
			// logo margin
			'wpnt_logo_margin_top'    => '0',
			'wpnt_logo_margin_right'  => '0',
			'wpnt_logo_margin_bottom' => '0',
			'wpnt_logo_margin_left'   => '0',

			// button options
			'wpnt_button_name'          => '',
			'wpnt_button_link'          => '#',
			'wpnt_button_class'         => '',
			'wpnt_button_id'            => '',
			'wpnt_button_border_radius' => '0',
			'wpnt_button_bg_color'      => 'FFFFFF',
			'wpnt_button_text_size'     => '13',
			'wpnt_button_text_color'    => '333333',
			'wpnt_button_open'          => '',
			'wpnt_button_script'        => '',
			'wpnt_button_code'          => '',
			// button padding
			'wpnt_button_padding_top'    => '0',
			'wpnt_button_padding_right'  => '0',
			'wpnt_button_padding_bottom' => '0',
			'wpnt_button_padding_left'   => '0',
			'wpnt_button_margin_top'    => '0',
			'wpnt_button_margin_right'  => '0',
			'wpnt_button_margin_bottom' => '0',
			'wpnt_button_margin_left'   => '0',

			// topbar global options
			'wpnt_place'            => '',
			'wpnt_topbar_content'   => '',
			'wpnt_width'            => '100',
			'wpnt_height'           => '50',
			'wpnt_bg_color'         => 'FFFFFF',
			'wpnt_bg_img'           => '',
			'wpnt_bg_repeat'        => 'no-repeat',
			'wpnt_position'         => 'top',

			// animation
			'wpnt_close_check' => 'on',
			'wpnt_smooth'      => 'on',
			'wpnt_reopen'      => 'on',
			'wpnt_time_move'   => '0.5',
			// mailchimp
			'wpnt_mc_placeholder' => 'Enter your email',
			'wpnt_mc_button_text' => 'Subscribe',
			'wpnt_mc_success_message' => 'Thank you for your subscribe'
		);

		/**
		 * 
		 * 
		 * @return void
		 */
		public function __construct()
		{
			/**
			 * define constants which used in plugin
			 */
			$this->define();

			/* Programming Mode. Remove this line once you done */
			//update_option(WPNT_PREFIX . 'default_options', $this->defaultOptions);

			register_activation_hook(__FILE__, array($this, 'activatePlugin'));
			$this->loadCore();
			add_action('wp', array($this, 'run'));
		}

		/**
		 * Define constants
		 * 
		 * @return void
		 */
		public function define()
		{
			$constants = array(
				'WPNT_PLUGIN_DIR'   => __DIR__,
				'WPNT_PLUGIN_URL'   => plugin_dir_url(__FILE__),
				'WPNT_PLUGIN_VER'   => '1.1.0',
				'WPNT_REQUIRE_VER'  => '4.0',
				'WPNT_AUTHOR_EMAIL' => 'duyngha@gmail.com',
				'WPNT_PREFIX'       => 'wpnt_',
				'WPNT_TEXTDOMAIN'   => 'wpnt',
			);

			foreach ($constants as $key => $value) {
				define($key, $value);
			}
		}

		/**
		 * plugin activation hook
		 * 
		 * @return void
		 */
		public function activatePlugin()
		{
			if (version_compare(get_bloginfo('version'), WPNT_REQUIRE_VER, '<')) {
				deactivate_plugins(basename(__FILE__) );
				wp_die('Current version of wordpress is lower require version (' . WPNT_REQUIRE_VER . ')');
			} else {
				// Save default settings and configution
				update_option(WPNT_PREFIX . 'default_options', $this->defaultOptions);
			}
		}

		/**
		 * load core of plugin
		 * 
		 * @return void
		 */
		public function loadCore()
		{
			$this->admin  = new WPNT\Core\WPNT_Admin($this);
			$this->ajax   = new WPNT\Core\WPNT_Ajax;
			$this->plugin = new WPNT\Core\PluginSettings;
		}

		/**
		 * 
		 */

		/**
		 * plugin run topbar
		 * 
		 * @return void
		 */
		public function run()
		{
			$pluginSettings = wpntGetPluginSettings();

			// detect mobile
			$detect = new \Mobile_Detect;

			if ($detect->isMobile()) {
				if ($pluginSettings['wpnt_mobile'] != 'on') {
					return;
				}
			}

			if ($detect->isTablet()) {
				if ($pluginSettings['wpnt_tablet'] != 'on') {
					return;
				}
			}

			if (is_admin()) return;

			$type = checkType();

			$lists = getListTopbars();

			if (!empty($lists)) {
				foreach ($lists as $item) {
					$settings = getTopbar($item->option_name);
					$topbar = new Topbar($this, $item->option_name);
					if (@$settings['wpnt_place'][0]['value'] == 'on') continue;
					if (@$settings['wpnt_place'][1]['value'] == 'on') {
						$topbar->wrapper();
						continue;
					}
					$where = $settings['wpnt_place'];
					if (is_array($where)) {
						foreach ($where as $place) {
							if ($place['place'] != $type) continue;
							if (!empty($place['value'])) {
								foreach ($place['value'] as $target) {
									switch ($type) {
										case 'cpt':
											if (is_singular($target)) {
												$topbar->wrapper();
											}
											break;
										case 'page':
											if (get_the_ID() == $target || in_array('all', $place['value'])) {
												$topbar->wrapper();
											}
											if ($target == 'front' && is_front_page()) {
												$topbar->wrapper();
											}
											break;
										case 'cate':
										case 'tax':
											if (get_queried_object()->term_id == $target) {
												$topbar->wrapper();
											}
											break;
									}
								}
							}
						}
					}
				}
			}
		}


	}
}

// kick it off
new WPNT;
