/*!
 * headroom.js v0.11.0 - Give your page some headroom. Hide your header until you need it
 * Copyright (c) 2020 Nick Williams - http://wicky.nillia.ms/headroom.js
 * License: MIT
 */
!function(global,factory){"object"==typeof exports&&"undefined"!=typeof module?module.exports=factory():"function"==typeof define&&define.amd?define(factory):(global=global||self).Headroom=factory()}(this,(function(){"use strict";function isBrowser(){return"undefined"!=typeof window}function passiveEventsSupported(){var supported=!1;try{var options={get passive(){supported=!0}};window.addEventListener("test",options,options),window.removeEventListener("test",options,options)}catch(err){supported=!1}return supported}function isSupported(){return!!(isBrowser()&&function(){}.bind&&"classList"in document.documentElement&&Object.assign&&Object.keys&&requestAnimationFrame)}function isDocument(obj){return 9===obj.nodeType}function isWindow(obj){return obj&&obj.document&&isDocument(obj.document)}function windowScroller(win){var doc=win.document,body=doc.body,html=doc.documentElement;return{scrollHeight:function(){return Math.max(body.scrollHeight,html.scrollHeight,body.offsetHeight,html.offsetHeight,body.clientHeight,html.clientHeight)},height:function(){return win.innerHeight||html.clientHeight||body.clientHeight},scrollY:function(){return void 0!==win.pageYOffset?win.pageYOffset:(html||body.parentNode||body).scrollTop}}}function elementScroller(element){return{scrollHeight:function(){return Math.max(element.scrollHeight,element.offsetHeight,element.clientHeight)},height:function(){return Math.max(element.offsetHeight,element.clientHeight)},scrollY:function(){return element.scrollTop}}}function createScroller(element){return isWindow(element)?windowScroller(element):elementScroller(element)}function trackScroll(element,options,callback){var isPassiveSupported=passiveEventsSupported(),rafId,scrolled=!1,scroller=createScroller(element),lastScrollY=scroller.scrollY(),details={};function update(){var scrollY=Math.round(scroller.scrollY()),height=scroller.height(),scrollHeight=scroller.scrollHeight();details.scrollY=scrollY,details.lastScrollY=lastScrollY,details.direction=scrollY>lastScrollY?"down":"up",details.distance=Math.abs(scrollY-lastScrollY),details.isOutOfBounds=scrollY<0||scrollY+height>scrollHeight,details.top=scrollY<=options.offset,details.bottom=scrollY+height>=scrollHeight,details.toleranceExceeded=details.distance>options.tolerance[details.direction],callback(details),lastScrollY=scrollY,scrolled=!1}function handleScroll(){scrolled||(scrolled=!0,rafId=requestAnimationFrame(update))}var eventOptions=!!isPassiveSupported&&{passive:!0,capture:!1};return element.addEventListener("scroll",handleScroll,eventOptions),update(),{destroy:function(){cancelAnimationFrame(rafId),element.removeEventListener("scroll",handleScroll,eventOptions)}}}function normalizeTolerance(t){return t===Object(t)?t:{down:t,up:t}}function Headroom(elem,options){options=options||{},Object.assign(this,Headroom.options,options),this.classes=Object.assign({},Headroom.options.classes,options.classes),this.elem=elem,this.tolerance=normalizeTolerance(this.tolerance),this.initialised=!1,this.frozen=!1}return Headroom.prototype={constructor:Headroom,init:function(){return Headroom.cutsTheMustard&&!this.initialised&&(this.addClass("initial"),this.initialised=!0,setTimeout((function(self){self.scrollTracker=trackScroll(self.scroller,{offset:self.offset,tolerance:self.tolerance},self.update.bind(self))}),100,this)),this},destroy:function(){this.initialised=!1,Object.keys(this.classes).forEach(this.removeClass,this),this.scrollTracker.destroy()},unpin:function(){!this.hasClass("pinned")&&this.hasClass("unpinned")||(this.addClass("unpinned"),this.removeClass("pinned"),this.onUnpin&&this.onUnpin.call(this))},pin:function(){this.hasClass("unpinned")&&(this.addClass("pinned"),this.removeClass("unpinned"),this.onPin&&this.onPin.call(this))},freeze:function(){this.frozen=!0,this.addClass("frozen")},unfreeze:function(){this.frozen=!1,this.removeClass("frozen")},top:function(){this.hasClass("top")||(this.addClass("top"),this.removeClass("notTop"),this.onTop&&this.onTop.call(this))},notTop:function(){this.hasClass("notTop")||(this.addClass("notTop"),this.removeClass("top"),this.onNotTop&&this.onNotTop.call(this))},bottom:function(){this.hasClass("bottom")||(this.addClass("bottom"),this.removeClass("notBottom"),this.onBottom&&this.onBottom.call(this))},notBottom:function(){this.hasClass("notBottom")||(this.addClass("notBottom"),this.removeClass("bottom"),this.onNotBottom&&this.onNotBottom.call(this))},shouldUnpin:function(details){var scrollingDown;return"down"===details.direction&&!details.top&&details.toleranceExceeded},shouldPin:function(details){var scrollingUp;return"up"===details.direction&&details.toleranceExceeded||details.top},addClass:function(className){this.elem.classList.add.apply(this.elem.classList,this.classes[className].split(" "))},removeClass:function(className){this.elem.classList.remove.apply(this.elem.classList,this.classes[className].split(" "))},hasClass:function(className){return this.classes[className].split(" ").every((function(cls){return this.classList.contains(cls)}),this.elem)},update:function(details){details.isOutOfBounds||!0!==this.frozen&&(details.top?this.top():this.notTop(),details.bottom?this.bottom():this.notBottom(),this.shouldUnpin(details)?this.unpin():this.shouldPin(details)&&this.pin())}},Headroom.options={tolerance:{up:0,down:0},offset:0,scroller:isBrowser()?window:null,classes:{frozen:"headroom--frozen",pinned:"headroom--pinned",unpinned:"headroom--unpinned",top:"headroom--top",notTop:"headroom--not-top",bottom:"headroom--bottom",notBottom:"headroom--not-bottom",initial:"headroom"}},Headroom.cutsTheMustard=isSupported(),Headroom})),function($){$&&($.fn.headroom=function(option){return this.each((function(){var $this=$(this),data=$this.data("headroom"),options="object"==typeof option&&option;options=$.extend(!0,{},Headroom.options,options),data||((data=new Headroom(this,options)).init(),$this.data("headroom",data)),"string"==typeof option&&(data[option](),"destroy"===option&&$this.removeData("headroom"))}))},$("[data-headroom]").each((function(){var $this=$(this);$this.headroom($this.data())})))}(window.Zepto||window.jQuery);